@echo off
setlocal EnableExtensions EnableDelayedExpansion

rem 切到批次檔所在資料夾
cd /d "%~dp0"

rem 使用 UTF-8，避免亂碼
chcp 65001 >nul

rem 標題
color 6
echo ========================================
echo 歡迎使用 LinPro 天堂私服版本查詢小幫手
echo ========================================
color 7

rem 需要系統管理員權限
net session >nul 2>&1
if %errorlevel% neq 0 (
  powershell -NoProfile -Command "Start-Process -FilePath '%~f0' -Verb RunAs"
  exit /b
)

rem 檢查 GetVersion.exe 是否在同目錄
if not exist ".\GetVersion.exe" (
  color C
  echo 錯誤：找不到 GetVersion.exe
  echo 請將此批次檔與 GetVersion.exe 放在同一資料夾再執行！
  color 7
  goto :PAUSE_END
)

rem === 只輸入 PID 的流程（數字+存在性檢查）===
:ASK_PID
echo ========================================
set "PID="
set /p "PID=請輸入需要查詢的天堂程式 PID（僅數字，直接 Enter 取消）："
if "%PID%"=="" goto :PAUSE_END

rem 僅接受數字 PID
echo %PID%| findstr /r "^[0-9][0-9]*$" >nul || (
  color C
  echo PID 格式錯誤：僅能為數字，請重試。
  color 7
  goto :ASK_PID
)

rem 檢查該 PID 是否存在
powershell -NoProfile -Command "if (Get-Process -Id %PID% -ErrorAction SilentlyContinue) { exit 0 } else { exit 1 }"
if errorlevel 1 (
  color C
  echo 找不到 PID %PID% 的行程，請確認後重試。
  color 7
  goto :ASK_PID
)

goto :RUN_QUERY

:RUN_QUERY
echo ========================================
echo 執行中：GetVersion.exe %PID%
echo ========================================

rem 以暫存檔捕捉輸出（存於系統暫存資料夾，不留在目前目錄）
set "TMPF=%TEMP%\gvtmp_%RANDOM%%RANDOM%.log"
> "%TMPF%" (
  echo [執行時間] %date% %time%
  echo PID = %PID%
)
GetVersion.exe %PID% >> "%TMPF%" 2>&1

echo.
echo ---------- 本次執行結果如下 ----------
type "%TMPF%"
echo ========================================

rem 解析輸出：只擷取 Lin 後面的連續英數為版本號
set "VERNUM="
for /f "usebackq delims=" %%V in (`
  powershell -NoProfile -Command ^
    "$t=Get-Content -Raw '%TMPF%'; if($t -match 'Lin([0-9A-Za-z]+)'){[Console]::Out.Write($matches[1])}"
`) do set "VERNUM=%%V"

rem 偵測錯誤訊息
set "HAS_ERR="
findstr /C:"Can't get version" "%TMPF%" >nul && set "HAS_ERR=1"

rem 取得時間戳（標準格式）
for /f "usebackq tokens=*" %%T in (`
  powershell -NoProfile -Command "(Get-Date).ToString('yyyy/MM/dd HH:mm')"
`) do set "NOW=%%T"

rem 顯示與記錄
if defined VERNUM (
  echo.
  color 6
  echo 您的天堂私服核心版本為 [ Ver.tw!VERNUM! ]
  set "RECOMM="
  call :MAP_LINPRO "!VERNUM!" RECOMM
  if defined RECOMM (
    echo 您需要至官網 !RECOMM! 才有支援此私服版本。
    call :SPECIAL_NOTE "!VERNUM!"
  )
  color 7
  >> "gvlog.txt" echo !NOW! 查詢 PID: %PID% 版本號: tw!VERNUM!
) else (
  echo.
  color C
  if defined HAS_ERR (
    echo 很抱歉，回報無法取得版本（或權限/目標程式狀態異常）
  ) else (
    echo 很抱歉，無法解析此天堂私服核心版本或尚未支援
  )
  echo 請確認是否輸入正確的 PID，或至官方討論區尋求幫助
  color 7
  >> "gvlog.txt" echo %NOW% 查詢 PID: %PID% 版本號: 查詢失敗/未支援
)

rem 清理暫存檔
del "%TMPF%" >nul 2>&1

goto :PAUSE_END

:MAP_LINPRO
rem %1 = VERNUM, %2 = OUTVAR name
set "%~2="
set "V=%~1"
for %%V in (21212 30102 30401 30513 31028) do if /I "%%V"=="%V%" set "%~2=LinPRO_182"
for %%V in (712060102 100611 712xp 21212b) do if /I "%%V"=="%V%" set "%~2=LinPRO_270"
for %%V in (12010402 12092701 13032701 13081901 150513200 160128200) do if /I "%%V"=="%V%" set "%~2=LinPRO_363"
for %%V in (160701201 1610202200 1705102501 1709152501 1711242501 1805232501 1901142505) do if /I "%%V"=="%V%" set "%~2=LinPRO_815"
exit /b

:SPECIAL_NOTE
rem 特殊版本提示（大小寫不敏感）
set "V=%~1"
for %%S in (12092701 13032701 13081901 160128200 712060102 712xp) do (
  if /I "%%S"=="%V%" (
    echo 特別注意：
    echo 如果此版本是波賽盾、科技盾、Mugen盾、太陽神、二哥登入器、天堂登陸器等有外掛偵測的盾類登陸器
    echo 請改下載 LinPro_Hades2 黑帝斯2 使用
    exit /b
  )
)
exit /b

:PAUSE_END
echo ========================================
pause
endlocal
